package gov.va.caret.portlet.action;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Blob;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.ProcessAction;

import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.pdmodel.PDDocument;

import com.liferay.counter.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.User;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.theme.ThemeDisplay;
import com.liferay.portal.util.PortalUtil;
import com.liferay.util.portlet.PortletProps;

import gov.va.caret.ApplicationWorkFlowException;
import gov.va.caret.controller.OnlineViewController;
import gov.va.caret.model.BgAsn;
import gov.va.caret.model.BoxGp;
import gov.va.caret.model.Docum;
import gov.va.caret.model.VcgAn;
import gov.va.caret.model.WorIm;
import gov.va.caret.model.impl.BgAsnImpl;
import gov.va.caret.model.impl.PersnImpl;
import gov.va.caret.model.impl.VcgAnImpl;
import gov.va.caret.model.support.ApplicationStatus;
import gov.va.caret.model.support.BoxedGroupAssociation;
import gov.va.caret.model.support.Person;
import gov.va.caret.model.support.Primary;
import gov.va.caret.model.support.Secondary;
import gov.va.caret.model.support.SecondaryTwo;
import gov.va.caret.model.support.VcgApplication;
import gov.va.caret.model.support.Veteran;
import gov.va.caret.model.support.WorkType;
import gov.va.caret.pdf.FileType;
import gov.va.caret.pdf.PopulatePDFImpl;
import gov.va.caret.pdf.VaForm1010cgFields;
import gov.va.caret.service.BoxGpLocalServiceUtil;
import gov.va.caret.service.CaretLocalServiceUtil;
import gov.va.caret.service.DocumLocalServiceUtil;
import gov.va.caret.service.PersnLocalServiceUtil;
import gov.va.caret.service.VcgAnLocalServiceUtil;
import gov.va.caret.service.ctssh.ServiceFacade;
import gov.va.caret.util.CaretStrPool;
import gov.va.caret.util.Toolbox;
import gov.va.caret.view.CaretParam;

public class OnlineActionCommand extends ActionCommand {
	

	@ProcessAction (name="saveApplicationVcg")
	public void saveApplicationVcg( ActionRequest request, ActionResponse actionResponse ) throws ApplicationWorkFlowException, PortalException, SystemException {
		
		String tracker = ParamUtil.getString(request, CaretStrPool.TRACKER, StringPool.BLANK );
		_log.info("reached save application.....");
		if ( ! CaretParam.isTracked( request, tracker, true ) ){
			_log.warn("TRACKER BLOCKING action... ");
			request.setAttribute(CaretStrPool.INVALID_REQUEST, true);
			return;
		}
		
		String personCategory = CaretStrPool.PERSON_CATEGORY_VETERAN;
		
		try {
			long vcgAnId = ParamUtil.getLong(request, "vcgAnId", 0); 
			long persnId = CaretParam.getPersnId(request);
			Veteran veteran = null;
			Primary primary = null;
			Secondary secondary = null;
			SecondaryTwo secondaryTwo = null;
			
			VcgApplication vcgApplication;
			StringBuilder message = new StringBuilder();
			ThemeDisplay themeDisplay = (ThemeDisplay) request.getAttribute( WebKeys.THEME_DISPLAY );
			String signed1010Form = LanguageUtil.get(themeDisplay.getLocale(), "signed-1010cg-form", " signed VA Form 10-10CG" );
			ServiceContext sc = CaretParam.setOnlineServiceContext(request);
			Set<Long> userIds = new HashSet<Long>();
			if ( vcgAnId > 0 ){  //Update to application by caregiver
				
				try {
					vcgApplication = new VcgApplication( VcgAnLocalServiceUtil.getVcgAn(vcgAnId) ); 
					veteran = new Veteran ( PersnLocalServiceUtil.getPersn( vcgApplication.getVeteranId() ) );
					userIds.add( veteran.getRootUserId() );
					if ( vcgApplication.getPrimaryId() > 0 && vcgApplication.getPrimaryId() == persnId ){
						if ( vcgApplication.getPrimarySignDate() != null ){
							throw new ApplicationWorkFlowException( "Application was signed in another session." );
						}
						boolean mediEnrolled = ParamUtil.getBoolean(request, "vcgAn_mediEnrolled" );
						vcgApplication.setMediEnrolled(mediEnrolled);
						vcgApplication.setPrimaryRelationship(ParamUtil.getString(request, "vcgAn_primaryRelationship"));
						vcgApplication.setPrimarySignDate( sc.getCreateDate() );
						
						primary = new Primary ( PersnLocalServiceUtil.getPersn( vcgApplication.getPrimaryId() ) );
						
						Primary formPrim = (Primary) CaretParam.loadModel(request, new Primary( new PersnImpl() ),
								Toolbox.getCollection("lastName","firstName","middleName",
														"birthDate","gender","ssn","email","phone","phone2","email", "otherHealthInsurance" ), 
														CaretStrPool.PRIMARY_PERSN  + StringPool.UNDERLINE);
						formPrim.setMediEnrolled(mediEnrolled);
						loadAddress( request, formPrim, CaretStrPool.PRIMARY_PERSN );
						boolean otherHealthInsurance = ParamUtil.getBoolean(request, "otherHealthInsurance", false);
						if ( !otherHealthInsurance ){
							formPrim.setOtherHealthInsurance(StringPool.BLANK);
						} else {
							formPrim.setOtherInsChecked(otherHealthInsurance);
						}
						if ( isRevision(formPrim, primary) ){
							CaretLocalServiceUtil.save( formPrim );
							vcgApplication.setPrimaryId( formPrim.getPersnId() );
							primary = formPrim;
						} else {
							CaretLocalServiceUtil.save( primary );
						}
						message.append(primary.getFullName());
						userIds.add( primary.getRootUserId() );
						personCategory = CaretStrPool.PERSON_CATEGORY_PRIMARY;
			      		_log.info("person is primary");
					}
					if ( vcgApplication.getSecondaryId() > 0 && vcgApplication.getSecondaryId() == persnId ){
						if ( vcgApplication.getSecondarySignDate() != null ){
							throw new ApplicationWorkFlowException( "Application was signed in another session." );
						}
						vcgApplication.setSecondaryRelationship( request.getParameter("vcgAn_secondaryRelationship") );
						vcgApplication.setSecondarySignDate( sc.getCreateDate() );
						
						secondary = new Secondary ( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryId() ) );
						
						Secondary formSec = (Secondary) CaretParam.loadModel(request, new Secondary( new PersnImpl() ), Toolbox.getCollection("lastName","firstName","middleName",
								"birthDate","gender","ssn","phone","phone2","email"), CaretStrPool.SECONDARY_PERSN  + StringPool.UNDERLINE);
						loadAddress( request, formSec, CaretStrPool.SECONDARY_PERSN );
						if ( isRevision(formSec, secondary) ){
							CaretLocalServiceUtil.save( formSec );
							vcgApplication.setSecondaryId( formSec.getPersnId() );
							secondary = formSec;
						} else {
							CaretLocalServiceUtil.save( secondary );
						}
						message.append(secondary.getFullName());
						userIds.add( secondary.getRootUserId() );
						personCategory = CaretStrPool.PERSON_CATEGORY_SECONDARY;
			      		_log.info("person is secondary");
					}
					if ( vcgApplication.getSecondaryTwoId() > 0 && vcgApplication.getSecondaryTwoId() == persnId ){
						if ( vcgApplication.getSecondaryTwoSignDate() != null ){
							throw new ApplicationWorkFlowException( "Application was signed in another session." );
						}
						vcgApplication.setSecondaryTwoRelationship( request.getParameter("vcgAn_secondaryTwoRelationship") );
						vcgApplication.setSecondaryTwoSignDate( sc.getCreateDate() );
						
						secondaryTwo = new SecondaryTwo( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryTwoId() ) );
						
						SecondaryTwo formSec2 = (SecondaryTwo) CaretParam.loadModel(request, new SecondaryTwo( new PersnImpl() ), Toolbox.getCollection("lastName","firstName","middleName",
								"birthDate","gender","ssn","phone","phone2","email"), CaretStrPool.SECONDARY_TWO_PERSN  + StringPool.UNDERLINE);
						loadAddress( request, formSec2, CaretStrPool.SECONDARY_TWO_PERSN );
						
						if ( isRevision(formSec2, secondaryTwo) ){
							CaretLocalServiceUtil.save( formSec2 );
							vcgApplication.setSecondaryTwoId( formSec2.getPersnId() );
							secondaryTwo = formSec2;
						} else {
							CaretLocalServiceUtil.save( secondaryTwo );
						}
						
						message.append(secondaryTwo.getFullName());
						userIds.add( secondaryTwo.getRootUserId() );
						personCategory = CaretStrPool.PERSON_CATEGORY_SECONDARYTWO;
			      		_log.info("person is secondarytwo");
					}
					
					message.append( signed1010Form );
					
				} catch (PortalException e) {
					throw new ApplicationWorkFlowException(e);
				} catch (SystemException e) {
					throw new ApplicationWorkFlowException(e);
				}
			} else {  // new Application submitted by Veteran....
				veteran = new Veteran(PersnLocalServiceUtil.getPersn( persnId ));
				vcgApplication = (VcgApplication) 
						CaretParam.loadModel(request, 
						new VcgApplication( new VcgAnImpl() ), 
						Toolbox.getCollection("lastTreatmentPlace","hospital","clinic","vaHealthEnrolled","primaryId","secondaryId","secondaryTwoId"), 
						CaretStrPool.VCGAN_UNDERLINE);
				
//				validateCaregivers( request.getPortletSession(), veteran, vcgApplication );
				
				Veteran formPerson = (Veteran) CaretParam.loadModel(request, new Veteran( new PersnImpl() ), Toolbox.getCollection("lastName","firstName","middleName",
						"birthDate","gender","ssn","phone","phone2","email","groupId"), CaretStrPool.VETERAN_PERSN_UNDERLINE);
				loadAddress( request, formPerson, CaretStrPool.VETERAN_PERSN );
				formPerson.setVaHealthEnrolled( vcgApplication.getVaHealthEnrolled() );

				saveOnlineAnswers(request);
				
				if ( isRevision(formPerson, veteran) ){
					CaretLocalServiceUtil.save( formPerson );
					veteran = formPerson;
				} else {
					CaretLocalServiceUtil.save( veteran );
				}
				userIds.add( veteran.getRootUserId() );//[22601]
				
				if ( vcgApplication.getPrimaryId() > 0 ){
					primary = new Primary( PersnLocalServiceUtil.getPersn( vcgApplication.getPrimaryId() ) ); 
					userIds.add( primary.getRootUserId() );
					String secondEmail = request.getParameter("primary_email2");
					if ( !Toolbox.isEmpty(  secondEmail ) ){
						primary.setEmail2( secondEmail );
						CaretLocalServiceUtil.save(primary);
					}
				}
				
				if ( vcgApplication.getSecondaryId() > 0 ){
					secondary = new Secondary( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryId() ) ); 
					userIds.add( secondary.getRootUserId() );//[22737]=rootUI // secondaryId=423811
					String secondEmail = request.getParameter("secondary_email2");
					if ( !Toolbox.isEmpty(  secondEmail ) ){
						secondary.setEmail2( secondEmail );
						CaretLocalServiceUtil.save(secondary);
					}
				}
				
				if ( vcgApplication.getSecondaryTwoId() > 0 ){
					secondaryTwo = new SecondaryTwo( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryTwoId() ) ); 
					userIds.add( secondaryTwo.getRootUserId() );
					String secondEmail = request.getParameter("secondaryTwo_email2");
					if ( !Toolbox.isEmpty(  secondEmail ) ){
						secondaryTwo.setEmail2( secondEmail );
						CaretLocalServiceUtil.save(secondaryTwo);
					}
				}
				
				vcgApplication.setVeteranId( veteran.getPersnId() );
				vcgApplication.setGroupId( veteran.getGroupId() );
				vcgApplication.setStatus( ApplicationStatus.NEED_SIGNATURE.name() );

				message.append(formPerson.getFullName()).append(signed1010Form);
				
			}
			
			WorIm workItem = null;
			if ( vcgAnId > 0 ){
				int signCount = 0;
				if ( vcgApplication.getSecondaryTwoSignDate() != null ) signCount++;
				if ( vcgApplication.getPrimarySignDate() != null ) signCount++;
				if ( vcgApplication.getSecondarySignDate() != null ) signCount++;
				
				int idCount = 0;
				if ( vcgApplication.getPrimaryId() > 0 ) idCount++;
				if ( vcgApplication.getSecondaryId() > 0 ) idCount++;
				if ( vcgApplication.getSecondaryTwoId() > 0 ) idCount++;
				
				if ( signCount > 0 && signCount == idCount ){
					vcgApplication.setSubmitDate( sc.getCreateDate() );
					vcgApplication.setReceivedDate( sc.getCreateDate() );
					vcgApplication.setStatus( ApplicationStatus.SUBMITTED.name() );
					long caregiverId = 0;
					if ( vcgApplication.getPrimaryId() > 0 ){
						caregiverId = vcgApplication.getPrimaryId(); 
						if ( primary == null ){
							primary = new Primary( PersnLocalServiceUtil.getPersn( vcgApplication.getPrimaryId() ) );
						}
						userIds.add( primary.getRootUserId() );
					} else if ( vcgApplication.getSecondaryId() > 0 ){
						caregiverId = vcgApplication.getSecondaryId();
						if ( secondary == null ){
							secondary = new Secondary( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryId() ) );
						}
						userIds.add( secondary.getRootUserId() );
					} else {
						caregiverId = vcgApplication.getSecondaryTwoId();
						userIds.add(caregiverId);
						if ( secondaryTwo == null ){
							secondaryTwo = new SecondaryTwo( PersnLocalServiceUtil.getPersn( vcgApplication.getSecondaryTwoId() ) );
						}
						userIds.add( secondaryTwo.getRootUserId() );
					}
					userIds.add( veteran.getRootUserId() );
					
					workItem = Toolbox.createWorkItem( sc, vcgApplication.getGroupId(), vcgApplication, WorkType.ONLINE_APP, veteran.getPersnId(), caregiverId );
				
				}
			}
			CaretLocalServiceUtil.save( vcgApplication );

//			update the session tracker...
			request.getPortletSession().setAttribute( CaretStrPool.APP_NDX, VcgAnLocalServiceUtil.getByPersnCount( CaretParam.getPersnId(request) ) );
			
			handleApplicationPdfDocument( request, vcgApplication, personCategory, veteran, primary, secondary, secondaryTwo );
			handleApplicationPoaDocument( request, vcgApplication );
			
			for ( long userId : userIds ){
				CaretLocalServiceUtil.addNote( Toolbox.createNote(
						sc.getCreateDate(), vcgApplication.getVcgAnId(), 0, userId, message.toString() ) );
			}
			if ( workItem != null ){
				String workAddedToQue = LanguageUtil.get(themeDisplay.getLocale(), "online-1010-work-added-to-q", "10-10CG was submitted to VA for Review." );
				CaretLocalServiceUtil.save( workItem );
				userIds = new HashSet<Long>();
				userIds.add(veteran.getRootUserId());
				if ( vcgApplication.getPrimaryId() > 0 ){
					userIds.add(new Person(PersnLocalServiceUtil.getPersn(vcgApplication.getPrimaryId())).getRootUserId());
				}
				if ( vcgApplication.getSecondaryId() > 0 ){
					userIds.add(new Person(PersnLocalServiceUtil.getPersn(vcgApplication.getSecondaryId())).getRootUserId());
				}
				if ( vcgApplication.getSecondaryTwoId() > 0 ){
					userIds.add(new Person(PersnLocalServiceUtil.getPersn(vcgApplication.getSecondaryTwoId())).getRootUserId());
				}
				for ( long userId : userIds ){
					CaretLocalServiceUtil.addNote( Toolbox.createNote(
							sc.getCreateDate(), vcgApplication.getVcgAnId(), 0, userId, workAddedToQue ) );
				}
			}
			_log.info( "finished Application creation...");
			
		} catch (IOException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}

	
	private boolean isRevision(Person formPerson, Person vcgPerson) {
		boolean isRevision = false;
		if ( !formPerson.getLastName().equals( vcgPerson.getLastName() ) ||
				!formPerson.getFirstName().equals( vcgPerson.getFirstName() ) ){
			_log.info("Last name change");
			isRevision = true;
		}
		if ( !Toolbox.isEmpty( formPerson.getMiddleName() ) &&  !formPerson.getMiddleName().equals( vcgPerson.getMiddleName() ) ) {
			_log.info("Updates to Person Middle Name");
			isRevision = true;
		}
		if ( ( ! formPerson.getAddress().equals( vcgPerson.getAddress() ) || !formPerson.getCity().equals( vcgPerson.getCity() ) ||
				! formPerson.getZip().equals( vcgPerson.getZip() ) || ! formPerson.getState().equals( vcgPerson.getState() ) ) ){
			_log.info("Updates to Person Address");
			isRevision = true;
		}
		if ( !Toolbox.isEmpty( formPerson.getSsn() ) && !formPerson.getSsn().equals( vcgPerson.getSsn() ) ) {
			_log.info("Updates to Person SSN");
			isRevision = true;
		}
		if ( formPerson.getBirthDate() != null && !formPerson.getBirthDate().equals( vcgPerson.getBirthDate() ) ) {
			 _log.info("Updates to Person Birthdate");
			 isRevision = true;
		}
		if ( formPerson.getRole() == Person.Role.VETERAN && formPerson.getGroupId() != vcgPerson.getGroupId() ) {
			_log.info("Veteran Facility Change");
			isRevision = true;
		}

		if ( !Toolbox.isEmpty( formPerson.getGender() ) && ! formPerson.getGender().equals( vcgPerson.getGender() ) ) {
			_log.info("Updates to Person Gender");
			isRevision = true;
		}
		
		if ( formPerson.getRole() == Person.Role.PRIMARY ){
			if ( !formPerson.getOtherHealthInsurance().equals( vcgPerson.getOtherHealthInsurance() ) ||
							((Primary)formPerson).getMediEnrolled() != ((Primary)formPerson).getMediEnrolled() ) {
				_log.info("Updates to Person Medicare/Medicaid enrollment");
				isRevision = true;
			} 
			if ( ((Primary)formPerson).getOtherInsChecked() != ((Primary)vcgPerson).getOtherInsChecked() ) {
				_log.info("Updates to Other Insurance");
				isRevision = true;
			}
		}

		if ( formPerson.getRole() == Person.Role.VETERAN ) {
			if ( ((Veteran)formPerson).getVaHealthEnrolled() != ((Veteran)vcgPerson).getVaHealthEnrolled() ) {
				_log.info("Updates to VA Health Enrollment");
				isRevision = true;
			}
		}
		if ( !isRevision ){
			vcgPerson.setPhone( formPerson.getPhone() );
			vcgPerson.setPhone2( formPerson.getPhone2() );
			vcgPerson.setEmail( formPerson.getEmail() );
		} else {
			formPerson.setStatus( CaretStrPool.ONLINE_REVISION );
			formPerson.setUserId( vcgPerson.getPersnUserId() );
		}
		return isRevision;
	}


	private Set<Long> validateCaregivers(PortletSession session, Veteran veteran, VcgApplication vcgApplication) throws ApplicationWorkFlowException {

		Set<Long> caregiverIds = new HashSet<Long>(); 
		
//		@SuppressWarnings("unchecked")
//		Set<Long> sessionStore = (Set<Long>) session.getAttribute(CaretStrPool.CAREGIVER_IDS);
//		if ( sessionStore != null ){
//			caregiverIds.addAll(sessionStore);
//		}
//		int size = 0;
//
//		String[] actives = veteran.getActives();
//		for ( String active: actives ){
//			long l = Long.valueOf(active);
//			if ( l > 0 ){
//				size++;
//				caregiverIds.add(l);
//			}
//		}
//		session.setAttribute( CaretStrPool.APP_NDX, size );
		
		if ( veteran.isPrimaryAvailable() ){
			caregiverIds.add( veteran.getPrimaryId() );
		}
		if ( veteran.isSecondaryAvailable() ){
			caregiverIds.add( veteran.getSecondaryId() );
		}
		if ( veteran.isSecondaryTwoAvailable() ){
			caregiverIds.add( veteran.getSecondaryTwoId() );
		}
		
		return caregiverIds;
	}



	private void handleApplicationPdfDocument( PortletRequest request, VcgAn vcgApplication, String personCategory, Person...persons ) throws PortalException, SystemException, IOException {

		long documId = 0;
		//get existing pdf if one exists for the application.....	
		if ( personCategory != CaretStrPool.PERSON_CATEGORY_VETERAN ){
			List<Docum> vcgAnDoc = DocumLocalServiceUtil.getByClass(vcgApplication.getVcgAnId(), PortalUtil.getClassNameId(VcgAn.class), FileType.TEN_TEN_CG.name() );
			if ( !vcgAnDoc.isEmpty() ){
				documId = vcgAnDoc.get(0).getDocumId();
			}
		}

		PDDocument pdfDoc = null;			
		Docum docum = null;
		if (documId == 0) {
			try{
				//pass a blank pdf
				URI uri = new URI( request.getScheme(),
						null,
						request.getServerName(),
						request.getServerPort(),
						request.getContextPath() + PopulatePDFImpl.FORM,
						null, null);

				pdfDoc = PDDocument.load( new URL( uri.toString() ) );
			} catch (IOException e) {
				ApplicationWorkFlowException.handleException(e);
			} catch (URISyntaxException e) {
				ApplicationWorkFlowException.handleException(e);
			}
		} else {
			try{
				//pass the pdf from database
				docum = DocumLocalServiceUtil.getDocum(documId);
				if (docum != null) {
					Blob blob = docum.getDocument();
					byte[] binaryData = blob.getBytes(1, (int) blob.length());

					InputStream inputStream = new ByteArrayInputStream(binaryData);
					pdfDoc = PDDocument.load(inputStream);
				}
			}catch (Exception e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
		Organization org = OrganizationLocalServiceUtil.getOrganization( persons[0].getGroupId() );
		String orgName = org == null? StringPool.BLANK : org.getName();
		try {
			VaForm1010cgFields vaForm1010cg = new VaForm1010cgFields((Veteran)persons[0], (Primary)persons[1], persons[2], persons[3],
					vcgApplication.getVaHealthEnrolled(),
					orgName,
					vcgApplication.getLastTreatmentPlace(), vcgApplication.getHospital(),  vcgApplication.getClinic(),
					vcgApplication.getMediEnrolled(),  
					persons[1] == null ? StringPool.BLANK : persons[1].getOtherHealthInsurance(),
					vcgApplication.getPrimaryRelationship(),  
					vcgApplication.getSecondaryRelationship(),
					vcgApplication.getSecondaryTwoRelationship(),
					pdfDoc,
					personCategory );
			new PopulatePDFImpl().generateAndPopulatePDF(request, vaForm1010cg);
		} catch (COSVisitorException e) {
			throw new ApplicationWorkFlowException(e);
		}
		String name = (String) request.getAttribute(CaretStrPool.TEN_TEN_FILE);

		//update if existing pdf or save if new pdf
		if ( name != null && !name.isEmpty() ){
			File uploadFile = new File( PropsUtil.get(CaretStrPool.FILE_TEMP_STORE) + name );
			File tempFile = null;
			//eSig -
			try{
				//primary
				User user;
				File eSigFile = null;
				if ( Toolbox.isMviEnabled() ){
					if ( personCategory == CaretStrPool.PERSON_CATEGORY_VETERAN ){
						user = UserLocalServiceUtil.getUser( persons[0].getRootUserId() );
						eSigFile = ServiceFacade.ESigVet(persons[0], user.getScreenName(), persons[0].getFullName(), user.getEmailAddress(), uploadFile, PropsUtil.get(CaretStrPool.FILE_TEMP_STORE));
					} else if ( personCategory == CaretStrPool.PERSON_CATEGORY_PRIMARY ){
						user = UserLocalServiceUtil.getUser( persons[1].getRootUserId() );
						eSigFile = ServiceFacade.ESigPG(persons[1], user.getScreenName(), persons[1].getFullName(), user.getEmailAddress(), uploadFile, PropsUtil.get(CaretStrPool.FILE_TEMP_STORE));
					} else if ( personCategory == CaretStrPool.PERSON_CATEGORY_SECONDARY ){
						user = UserLocalServiceUtil.getUser( persons[2].getRootUserId() );
						eSigFile = ServiceFacade.ESigSG1(persons[2], user.getScreenName(), persons[2].getFullName(), user.getEmailAddress(), uploadFile, PropsUtil.get(CaretStrPool.FILE_TEMP_STORE));
					} else if ( personCategory == CaretStrPool.PERSON_CATEGORY_SECONDARYTWO ){
						user = UserLocalServiceUtil.getUser( persons[3].getRootUserId() );
						eSigFile = ServiceFacade.ESigSG2(persons[3], user.getScreenName(), persons[3].getFullName(), user.getEmailAddress(), uploadFile, PropsUtil.get(CaretStrPool.FILE_TEMP_STORE));
					} else {
						_log.error("USER CATEGORY NOT SET");
					}
				}
				if ( eSigFile == null ){
					_log.error("eSig File was NULL");
				} else {
					tempFile = uploadFile;
					uploadFile = eSigFile;
				}
			} catch ( Exception e ){
				_log.error("eSig error...See stack trace");
				ApplicationWorkFlowException.handleException(e);
			}
			
			
			InputStream inputStream = new FileInputStream( uploadFile );
			OutputBlob outputBlob = new OutputBlob ( inputStream, uploadFile.length() );

			if(documId == 0) {
				_log.info("==========creating new pdf in db");

				documId = CounterLocalServiceUtil.increment( Docum.class.getName() );
				Docum tenCgDocument = DocumLocalServiceUtil.createDocum(documId);
				tenCgDocument.setDocument( outputBlob );
				tenCgDocument.setDeleted(false);
				tenCgDocument.setClassPk( vcgApplication.getVcgAnId() );
				tenCgDocument.setClassId( PortalUtil.getClassNameId(VcgAn.class) );
				tenCgDocument.setType( FileType.TEN_TEN_CG.name() );
				tenCgDocument.setName(name);
				try {
					DocumLocalServiceUtil.addDocum( tenCgDocument );
//					FileUtil.delete(uploadFile);
				} catch (SystemException e) {
					ApplicationWorkFlowException.handleException(e);
				}
			}else if (docum != null) {
				_log.info("==========updating existing pdf in db");
				
				docum.setDocument( outputBlob );

				try {
					DocumLocalServiceUtil.updateDocum( docum );
//					FileUtil.delete(uploadFile);
				} catch (SystemException e) {
					ApplicationWorkFlowException.handleException(e);
				}								
			}
		}
	}

	public void handleApplicationPoaDocument ( PortletRequest request, VcgAn vcgApplication ) throws FileNotFoundException, SystemException {
		if ( request.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH) != null ){
			String path = (String) request.getPortletSession().getAttribute(CaretStrPool.POA_FILE_PATH);
			String name = (String) request.getPortletSession().getAttribute(CaretStrPool.POA_FILE_NAME);
			File uploadFile = new File(path);
			InputStream inputStream = new FileInputStream( uploadFile );
			OutputBlob outputBlob = new OutputBlob ( inputStream, uploadFile.length() );
			
			long documId = CounterLocalServiceUtil.increment( Docum.class.getName() );
			Docum poaDocument = DocumLocalServiceUtil.createDocum(documId);
			poaDocument.setDocument(outputBlob);
			poaDocument.setDeleted(false);
			poaDocument.setClassPk( vcgApplication.getVcgAnId() );
			poaDocument.setClassId( PortalUtil.getClassNameId(VcgAn.class) );
			poaDocument.setType( FileType.POA.name() );
			poaDocument.setName(name);
			try {
				DocumLocalServiceUtil.addDocum( poaDocument );
				request.getPortletSession().removeAttribute(CaretStrPool.POA_FILE_NAME);
				FileUtil.delete(uploadFile);
			}
			catch (Exception e) {
				ApplicationWorkFlowException.handleException(e);
			}
		}
	}
	

	@ProcessAction (name="uploadFile")
	public void uploadFile ( ActionRequest request, ActionResponse actionResponse ) throws FileNotFoundException{
		UploadPortletRequest uploadRequest = PortalUtil.getUploadPortletRequest(request);
		for ( Enumeration<String> enume = PortalUtil.getUploadPortletRequest(request).getParameterNames(); enume.hasMoreElements() ; ){
			String name = enume.nextElement();
			_log.info(name + ":" + ParamUtil.getString(request, name));
		}
		
		long size = uploadRequest.getSize("file");
		_log.info("size=" + size );
		if ( size == 0 ){
			_log.info("returning since size is 0...");
			return;
		}

		File uploadFile = uploadRequest.getFile("file");
		String tempLocation = PropsUtil.get(CaretStrPool.FILE_TEMP_STORE);
		String name = uploadRequest.getFileName("file");
		
		File file = new File(tempLocation + name);
		try {
			FileUtil.copyFile( uploadFile, file );
		} catch (IOException e) {
			ApplicationWorkFlowException.handleException(e);
		}
		
		_log.info("path is ... " + uploadFile.getPath() + ", name=" + name );
		request.getPortletSession().setAttribute(CaretStrPool.POA_FILE_PATH, file.getPath() );
		request.getPortletSession().setAttribute(CaretStrPool.POA_FILE_NAME, name);
	}
	
	public void loadApplication( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String context = ParamUtil.getString( actionRequest, "context", StringPool.BLANK );
		if ( "onlineQuestionaire".equals(context) ){
			saveOnlineQuestions(actionRequest, actionResponse);
		}
		
		OnlineViewController.get().loadApplication(actionRequest); 
	}
	
	public void cancelApplication( ActionRequest actionRequest, ActionResponse actionResponse ) {
		String context = ParamUtil.getString( actionRequest, "context", StringPool.BLANK );
		if ( "onlineQuestionaire".equals(context) ){
			saveOnlineQuestions(actionRequest, actionResponse);
		}
		
		try {
			OnlineViewController.get().cancelApplication(actionRequest);
		} catch (PortalException e) {
			ApplicationWorkFlowException.handleException(e);
		} catch (SystemException e) {
			ApplicationWorkFlowException.handleException(e);
		} 
	}
	
	public void saveOnlineQuestions( ActionRequest actionRequest, ActionResponse actionResponse ){
		try {
			
			boolean enrolled = ParamUtil.getBoolean(actionRequest, "enrolled-in-va-health" );
			actionRequest.setAttribute(CaretStrPool.VETERAN_VA_HEALTH_ENROLLED, enrolled );
			
			boolean dateDischarged = ParamUtil.getBoolean(actionRequest, "military-discharged-date" );
			boolean activeDuty = ParamUtil.getBoolean(actionRequest, "is-veteran-in-military" );
			boolean needCare = ParamUtil.getBoolean(actionRequest, "needs-assistance-basic-functions" );
			
//			long persnId = CaretParam.getPersnId(actionRequest);

			Set<Long> boxGroups = new HashSet<Long>();
			actionRequest.getPortletSession().setAttribute(CaretStrPool.ONLINE_QUESTIONAIRE_YN, boxGroups);

			
			List<BoxGp> groups = BoxGpLocalServiceUtil.getBoxGroups(CaretStrPool.ONLINE_QUESTIONAIRE_YN, CaretStrPool.ONLINE_QUESTIONAIRE_YN);
			for ( BoxGp boxGp: groups ){
				if ( boxGp.getLabel().equals( "enrolled-in-va-health" ) ){
					if ( enrolled ){
						boxGroups.add( boxGp.getBoxGpId() );
					}
					continue;
				}
				if ( boxGp.getLabel().equals( "military-discharged-date" ) ){
					if ( dateDischarged ){
						boxGp.getBoxGpId();
					}
					continue;
				}
				if ( boxGp.getLabel().equals( "is-veteran-in-military" ) ){
					if ( activeDuty ){
						boxGp.getBoxGpId();
					}
					continue;
				}
				if ( boxGp.getLabel().equals( "needs-assistance-basic-functions" ) ){
					if ( needCare ){
						boxGp.getBoxGpId();
					}
					continue;
				}
			}				
		} catch (ApplicationWorkFlowException e) {
			ApplicationWorkFlowException.handleException(e);
		}
	}
	
	public void saveOnlineAnswers ( ActionRequest actionRequest ) throws ApplicationWorkFlowException {
		
		@SuppressWarnings("unchecked")
		Set<Long> boxGroups = (Set<Long>) actionRequest.getPortletSession().getAttribute(CaretStrPool.ONLINE_QUESTIONAIRE_YN);
		if ( boxGroups == null ){
			return;
		}
		long persnId = CaretParam.getPersnId( actionRequest );
		for ( Long boxGpId : boxGroups ){
			BgAsn bgAsn = new BgAsnImpl();
			bgAsn.setBoxGpId( boxGpId );
			bgAsn.setOwnerId( persnId );
			bgAsn.setSelected( true );
			CaretLocalServiceUtil.save( new BoxedGroupAssociation(bgAsn) );
		}
	}
	
	public void loadAddress(ActionRequest request, Person persn, String prefix) throws ApplicationWorkFlowException {
		persn.setCountry( ParamUtil.get(request, prefix+"_country" , StringPool.BLANK) );
		OnlineViewController.get().loadPersnAddress( request, persn, prefix );
		
		if ( PortletProps.get("required."+ persn.getRole().getLabel() + ".input").contains("uspsValidation") &&
				!persn.isForeigner() ){
			persn.setValidAddress(true);
		}
	}

	
	
	private static Log _log = LogFactoryUtil.getLog( OnlineActionCommand.class );
	
}
